package usb4allConfigGenerator;

import java.util.Vector;

public class DeviceDescriptor {
	
	private static final String ls = System.getProperty("line.separator");
	
	//constantes para los BDT de los EP
	private static final int EP_OUT = 0;
	private static final int EP_IN = 1;
	
	private float usbSpecReleaseNumber;
	private int classCode;
	private int subClassCode;
	private int protocolCode;
	private int ep0BuffSize;
	private int vendorId;
	private int productId;
	private int deviceReleaseNumber;
	private Vector<Configuration> configurations;
	private Vector<StringDescriptor> stringDescriptors;
	
	//calculados
	private String sUsbSpecReleaseNumber;
	private int numberOfPosibleConfigurations;
	private int manufacturerStringNumber;
	private int productStringIndex;
	private int deviceSerialNumberStringIndex;
	
	public void addStringDescriptor(StringDescriptor sd){
		stringDescriptors.addElement(sd);
	}
	
	public DeviceDescriptor(float usbSpecReleaseNumber, int classCode, int subClassCode, int protocolCode, int ep0BuffSize, int vendorId, int productId, int deviceReleaseNumber) {
		super();
		// TODO Auto-generated constructor stub
		this.usbSpecReleaseNumber = usbSpecReleaseNumber;
		this.classCode = classCode;
		this.subClassCode = subClassCode;
		this.protocolCode = protocolCode;
		this.ep0BuffSize = ep0BuffSize;
		this.productId = productId;
		this.vendorId = vendorId;
		this.deviceReleaseNumber = deviceReleaseNumber;
		//incializo los vectores
		configurations = new Vector<Configuration>() ;
		stringDescriptors = new Vector<StringDescriptor>();
	}
	public void addConfiguration(Configuration cfg){
		configurations.addElement(cfg);
	}
	
	
	public String generateDescriptorH(){
		//TODO generalizar para mas de una configuracion
		StringBuffer genCode = new StringBuffer();
		//primero hago append de la parte fija
		genCode.append("//Autogenerated file using USB4ALL Descriptor generator V1.0  Author: Rafael Fernandez" + ls + ls +
				"#ifndef USBDSC_H" + ls + 
				"#define USBDSC_H" + ls +
				"// I N C L U D E S ************************************************" + ls +
				"#include \"system\\typedefs.h\"" + ls +
				"#include \"autofiles\\usbcfg.h\" " + ls +
				"#include \"system\\usb\\usb.h\" " + ls + ls +
				"//D E F I N I T I O N S ******************************************" + ls);
		
		genCode.append("#define MAX_NUM_INT             "+ getMaxNumInt()+ " // For tracking Alternate Setting" + ls +
				"#define EP0_BUFF_SIZE           "+ep0BuffSize+ "   // 8, 16, 32, or 64" + ls);
		//por cada configuracion tengo que pedir que llenen con sus datos
		for(int i=0;i<configurations.size();i++){
			genCode.append(configurations.elementAt(i).generateDescriptorH(i));
		}
		
		//final fijo por ahora (hasta generalizar las CFGs
		genCode.append("//		 E X T E R N S **************************************************" + ls +
				"extern rom USB_DEV_DSC device_dsc;" + ls +
				"extern CFG01;" + ls +
				"extern rom const unsigned char *rom USB_CD_Ptr[];" + ls +
				"extern rom const unsigned char *rom USB_SD_Ptr[];" + ls +
				"#endif //USBDSC_H");

		return genCode.toString();
	}
	public int getMaxNumInt(){
		//TODO generalizar para revisar el maximo de interfaces de todas las configuraciones
		return configurations.elementAt(0).getNumInterfaces();
	}
	
	public void calcularAtributos(){
		//calculo los atributos calculados
		if (usbSpecReleaseNumber==1.0) sUsbSpecReleaseNumber = "0x0100";
		else if (usbSpecReleaseNumber==1.1) sUsbSpecReleaseNumber = "0x0101";
		else if (usbSpecReleaseNumber==2.0) sUsbSpecReleaseNumber = "0x0200";
		
		//cantidad de posibles configuraciones
		numberOfPosibleConfigurations = configurations.size();
		
	}
	
	public String generateDescriptorC(){
		StringBuffer genCode = new StringBuffer();
		genCode.append(getStartDescriptorC());
		calcularAtributos();		 
		String genConParams = new String();
		
		genConParams = "    "+ sUsbSpecReleaseNumber +",				// USB Spec Release Number in BCD format" + ls +
				"    0x" + Integer.toHexString(classCode) +",				// Class Code" + ls +
				"    0x" + Integer.toHexString(subClassCode) +",				// Subclass code" + ls +
				"    0x" + Integer.toHexString(protocolCode) +",				// Protocol code" + ls +
				/*ep0BuffSize + */"    EP0_BUFF_SIZE,				// Max packet size for EP0, see usbcfg.h" + ls +
				"    0x" + Integer.toHexString(vendorId) + ",				// Vendor ID" + ls +
				"    0x" + Integer.toHexString(productId) +",				// Product ID: PICDEM FS USB (DEMO Mode)" + ls +
				"    0x" + Integer.toHexString(deviceReleaseNumber) +",				// Device release number in BCD format" + ls +
				"    0x" + Integer.toHexString(manufacturerStringNumber) +",				// Manufacturer string index" + ls +
				"    0x" + Integer.toHexString(productStringIndex) +",				// Product string index" + ls +
				"    0x" + Integer.toHexString(deviceSerialNumberStringIndex) +",				// Device serial number string index" + ls +
				"    0x" + Integer.toHexString(numberOfPosibleConfigurations) +",				// Number of possible configurations" + ls +
				"};"+ ls ;
		
		genCode.append(genConParams);
		for(int i=0;i<configurations.size();i++){
			genCode.append(configurations.elementAt(i).generateDescriptorC(i));
		}
		
		
		for (int i=0; i<stringDescriptors.size();i++){
			genCode.append(stringDescriptors.elementAt(i).generateDescriptorC(i));
		}
		genCode.append(getcdPtrsDescriptorC());
		genCode.append(getsdPtrsDescriptorC());
		return genCode.toString();
	}
	private String getStartDescriptorC(){
	return "//Autogenerated file using USB4ALL Descriptor generator V1.0  Author: Rafael Fernandez" + ls + ls +
		   "/** I N C L U D E S *************************************************/" + ls +
		   "#include \"system\\typedefs.h\"" + ls +
		   "#include \"system\\usb\\usb.h\"" + ls +
		   "/** C O N S T A N T S ************************************************/" + ls +
		   "#pragma romdata _device_dsc" + ls + ls +
		   "//	 Device Descriptor " + ls +
		   "rom USB_DEV_DSC device_dsc=" +  ls +
		   "{" +  ls +
		   "    sizeof(USB_DEV_DSC),    // Size of this descriptor in bytes" + ls +
		   "    DSC_DEV,                // DEVICE descriptor type" + ls;
	}
	
	public String generateMmapH(int ppBuffering){
		StringBuffer genCode = new StringBuffer();
		genCode.append("//Autogenerated file using USB4ALL Descriptor generator V1.0  Author: Rafael Fernandez" + ls + ls);
		//TODO hacer en funcion del ping pong buffering. Por ahora esta para el 0
		//header
		genCode.append("#ifndef USBMMAP_H" + ls+
				"#define USBMMAP_H"+ls);
		//includes
		genCode.append("// I N C L U D E S **********************************************************"+ls+ls);
		genCode.append("#include <p18cxxx.h>		//sino no encontraba el UEP1" + ls+
				"#include \"system\\typedefs.h\"" +ls+
				"#include \"usb4all\\boot\\boot.h\" //mia"+ls);
		//definitions
		genCode.append("// D E F I N I T I O N S ****************************************************"+ls+ls);

		genCode.append("//Buffer Descriptor Status Register Initialization Parameters" + ls +
				"#define _BSTALL     0x04                //Buffer Stall enable" + ls +
				"#define _DTSEN      0x08                //Data Toggle Synch enable" + ls +
				"#define _INCDIS     0x10                //Address increment disable" + ls +
				"#define _KEN        0x20                //SIE keeps buff descriptors enable" + ls +
				"#define _DAT0       0x00                //DATA0 packet expected next" + ls +
				"#define _DAT1       0x40                //DATA1 packet expected next" + ls +
				"#define _DTSMASK    0x40                //DTS Mask" + ls +
				"#define _USIE       0x80                //SIE owns buffer" + ls +
				"#define _UCPU       0x00                //CPU owns buffer" + ls + ls +
				"//USB Device States - To be used with [byte usb_device_state]" + ls +
				"#define DETACHED_STATE          0" + ls +
				"#define ATTACHED_STATE          1" + ls +
				"#define POWERED_STATE           2" + ls +
				"#define DEFAULT_STATE           3" + ls +
				"#define ADR_PENDING_STATE       4" + ls +
				"#define ADDRESS_STATE           5" + ls +
				"#define CONFIGURED_STATE        6" + ls+ls);
		
		//tamao de los endpoints y max_ep_number
		//TODO el tamao de los endpoints va a quedar deprecated con el update del firmware
		genCode.append("//		tamao de los endpoints(va a quedar deprecated)" +ls+ls+
				"#define USBGEN_EP_SIZE 64" + ls +
				"#define MAX_EP_NUMBER           "+ new UsbSharedMemAllocator(this).getMAX_EP_NUMBER()+"          // max nro de endpoints"+ls+ls);
		
		genCode.append("//Memory Types for Control Transfer - used in USB_DEVICE_STATUS" +ls+ls+
				"#define _RAM 0" +ls+
				"#define _ROM 1" +ls+ls);
		//types
		genCode.append("// T Y P E S ****************************************************************" +ls+ls+
				"typedef union _USB_DEVICE_STATUS" +ls+
				"{" +ls+
				"    byte _byte;" +ls+
				"    struct" +ls+
				"    {" +ls+
				"        unsigned RemoteWakeup:1;// [0]Disabled [1]Enabled: See usbdrv.c,usb9.c" +ls+
				"        unsigned ctrl_trf_mem:1;// [0]RAM      [1]ROM" +ls+
				"    };" +ls+
				"} USB_DEVICE_STATUS;" +ls+
				"" +ls+
				"typedef union _BD_STAT" +ls+
				"{" +ls+
				"    byte _byte;" +ls+
				"    struct{" +ls+
				"        unsigned BC8:1;" +ls+
				"        unsigned BC9:1;" +ls+
				"        unsigned BSTALL:1;              //Buffer Stall Enable" +ls+
				"        unsigned DTSEN:1;               //Data Toggle Synch Enable" +ls+
				"        unsigned INCDIS:1;              //Address Increment Disable" +ls+
				"        unsigned KEN:1;                 //BD Keep Enable" +ls+
				"        unsigned DTS:1;                 //Data Toggle Synch Value" +ls+
				"        unsigned UOWN:1;                //USB Ownership" +ls+
				"    };" +ls+
				"    struct{" +ls+
				"        unsigned BC8:1;" +ls+
				"        unsigned BC9:1;" +ls+
				"        unsigned PID0:1;" +ls+
				"        unsigned PID1:1;" +ls+
				"        unsigned PID2:1;" +ls+
				"        unsigned PID3:1;" +ls+
				"        unsigned :1;" +ls+
				"        unsigned UOWN:1;" +ls+
				"    };" +ls+
				"    struct{" +ls+
				"        unsigned :2;" +ls+
				"        unsigned PID:4;                 //Packet Identifier" +ls+
				"        unsigned :2;" +ls+
				"    };" +ls+
				"} BD_STAT;                              //Buffer Descriptor Status Register" +ls+
				"" +ls+
				"typedef union _BDT" +ls+
				"{" +ls+
				"    struct" +ls+
				"    {" +ls+
				"        BD_STAT Stat;" +ls+
				"        byte Cnt;" +ls+
				"        byte ADRL;                      //Buffer Address Low" +ls+
				"        byte ADRH;                      //Buffer Address High" +ls+
				"    };" +ls+
				"    struct" +ls+
				"    {" +ls+
				"        unsigned :8;" +ls+
				"        unsigned :8;" +ls+
				"        byte* ADR;                      //Buffer Address" +ls+
				"    };" +ls+
				"} BDT;                                  //Buffer Descriptor Table" +ls+ls);
		//Externs
		
		genCode.append("// E X T E R N S ************************************************************" + ls + ls +
				"extern byte usb_device_state;" + ls +
				"extern USB_DEVICE_STATUS usb_stat;" + ls +
				"extern byte usb_active_cfg;" + ls +
				"extern byte usb_alt_intf[MAX_NUM_INT];" + ls +
				"extern byte epOutSize[MAX_EP_NUMBER];" + ls +
				"extern byte epInSize[MAX_EP_NUMBER];"+ ls +
				"extern rom unsigned char ROM_MAX_EP_NUMBER;"+ls+ls);
				
		genCode.append(new UsbSharedMemAllocator(this).getBDTsExterns(0));
		// externs del endpoint 0
		
		genCode.append("extern volatile far CTRL_TRF_SETUP SetupPkt;" +ls+
				"extern volatile far CTRL_TRF_DATA CtrlTrfData;"+ls+ls);

		//externs de los buffers de los endpoints
		
		genCode.append(new UsbSharedMemAllocator(this).getUSBBuffersExterns(0));
		
		//public prototypes
		genCode.append("// P U B L I C  P R O T O T Y P E S *****************************************" + ls+ls+
				"void USBInitEPs(void);" + ls);
		//end h Header endif
		genCode.append("#endif //USBMMAP_H");
		return genCode.toString();
	}

	public String getEpBDT(int endpointNumber,int direction){
		return "ep"+endpointNumber+"B"+(direction==EP_OUT ? "o" : "i");
	}
	
	private String sectionAMmapC(int ppBuffering){
		StringBuffer sb = new StringBuffer();
		sb.append("// Section A: Buffer Descriptor Table"+ls);
		//TODO hacer en funcion del ping pong buffering. Por ahora esta para el 0
		//TODO mejorarlo para que solo instancie los BDT que se usan
		for(int i = 0;i<15;i++){
			sb.append("#if("+i+ " <= MAX_EP_NUMBER)" +ls+
					"volatile far BDT "+ getEpBDT(i,EP_OUT)+";" +ls+
					"volatile far BDT "+ getEpBDT(i,EP_IN)+";" +ls+
					"#endif"+ls+ls);
		}
		return sb.toString();
	}
		
	private String sectionBMmapC(){
		StringBuffer sb = new StringBuffer();
		sb.append("// Section B: EP0 Buffer Space"+ls);
		sb.append("volatile far CTRL_TRF_SETUP SetupPkt;"+ls);
		sb.append("volatile far CTRL_TRF_DATA CtrlTrfData;"+ls+ls);
			
		return sb.toString();
	}

	private String sectionCMmapC(int ppBuffering){
		//TODO hacerlo para otros pingpong buffering distinto del 0
		StringBuffer sb = new StringBuffer();
		sb.append("// Section C: Endpoints Buffers"+ls+ls);
		//TODO hacerlo para mas de una configuracion  y una interface
		//obtengo todos los endpoints
		//por ahora solo los de conf1 y int1
		sb.append(new UsbSharedMemAllocator(this).getUsbEndpointBuffers(ppBuffering));
		sb.append("#pragma udata"+ls);
		//defino ROM_MAX_EP_NUMBER que es el MAX_EP_NUMBER guardado en rom
		//de esta manera al cambiar el nro de endpoints ese nro se guarda en una 
		//posicion en ram y luego se utiliza en el handler manager (previa cargada en ram)
		sb.append(ls+"#pragma romdata _rom_usb_endpoints_init"+ls);
		sb.append("//defino el ROM_MAX_EP_NUMBER igual al define MAX_EP_NUMBER"+ls);
		sb.append("rom unsigned char ROM_MAX_EP_NUMBER=MAX_EP_NUMBER;"+ls+ls);
		return sb.toString();
	}
	
	
	private String sectionInitEpBuffers(int ppBuffering){
//		TODO hacerlo para otros pingpong buffering distinto del 0
		StringBuffer sb = new StringBuffer();
		sb.append("	#pragma code _usb_endpoints_init"+ls);
		//TODO sacar el codigo deprecated cuando se generalize el firmware
		//inicio codigo deprecated
		sb.append("#define USBGEN_UEP              UEP1" + ls +
				"#define BOOT_UEP                UEP1 //uso endpoint 2 para bootloader" + ls +
				"//		defino endpoints usados por el modulo" + ls +
				"//		la idea es que los endpoints se inicialicen sin depender del modulo que los use" + ls +
				"//		Por ahora dejo los IFNDEF para no cambiar el codigo de initEps" + ls +
				"		#ifndef USBGEN_BD_OUT" + ls +
				"			#define USBGEN_BD_OUT           ep1Bo" + ls +
				"		#endif" + ls +
				"		#ifndef USBGEN_BD_IN" + ls +
				"			#define USBGEN_BD_IN            ep1Bi" + ls +
				"		#endif" + ls);
		//fin codigo deprecated
		sb.append(new UsbSharedMemAllocator(this).getUSBInitEPs(ppBuffering));
		
		
		return sb.toString();
	}

	
	
	public String generateMmapC(int ppBuffering){
		StringBuffer genCode = new StringBuffer();
		//agrego autogenerado
		genCode.append("//Autogenerated file using USB4ALL Descriptor generator V1.0  Author: Rafael Fernandez" + ls + ls);
		//agrego includes
		genCode.append("// I N C L U D E S *********************************************************" + ls +
				"#include \"system\\typedefs.h\"" + ls +
				"#include \"system\\usb\\usb.h\"" + ls +
				"#include \"usb4all\\boot\\boot.h\" //mia" + ls);
		//agrego variables globales
		genCode.append("// U S B  G L O B A L  V A R I A B L E S ***********************************" + ls +
				"#pragma udata" + ls +
				"byte usb_device_state;          // Device States: DETACHED, ATTACHED, ..." + ls +
				"USB_DEVICE_STATUS usb_stat;     // Global USB flags" + ls +
				"byte usb_active_cfg;            // Value of current configuration" + ls +
				"byte usb_alt_intf[MAX_NUM_INT]; // Array to keep track of the current alternate" + ls +
				"                                // setting for each interface ID" + ls);
		//agrego vectores con tamao de los endpoints
		genCode.append(endpointVectorSize());
		//usb fixed location variables
		genCode.append("// U S B  F I X E D  L O C A T I O N  V A R I A B L E S ********************" +ls+ls+
				"#pragma udata usbram4=0x400     //See Linker Script,usb4:0x400-0x4FF(256-byte)"+ls);
		//section A
		genCode.append(sectionAMmapC(0));
		//section B
		genCode.append(sectionBMmapC());
		//section C
		genCode.append(sectionCMmapC(0));
		//Init endpoint buffers
		genCode.append(sectionInitEpBuffers(0));
		
		
		return genCode.toString();
	}
	
	private String endpointVectorSize(){
		StringBuffer sbOut = new StringBuffer();
		StringBuffer sbIn = new StringBuffer();
		UsbSharedMemAllocator uma = new UsbSharedMemAllocator(this);
		Vector<Endpoint> ae = uma.getAllEndpoints();
		sbOut.append("byte epOutSize[MAX_EP_NUMBER] = {");
		sbIn.append("byte epInSize[MAX_EP_NUMBER] = {");
		
		for (int i=1; i<=uma.getMAX_EP_NUMBER();i++){
			//busco el endpoint i y la direccion in o out para sacar el tam de los endpoints 
			for (int e=0;e<ae.size(); e++){
				if (ae.elementAt(e).getEndpointNumber()==i){
					
					if (ae.elementAt(e).getDirection()==Endpoint.OUT){
						//el endpoint i es out
						if (i!=1) sbOut.append(",");
						sbOut.append(ae.elementAt(i).getEndpointSize());
					}
					else {
						//el endpoint i es in
						if (i!=1) sbIn.append(",");
						sbIn.append(ae.elementAt(i).getEndpointSize());
					}
				}
			}
		}
		sbOut.append("};"+ls);
		sbIn.append("};"+ls);
		return sbOut.toString() + ls + sbIn.toString()+ls;
	}
	
	
	/*
	//	 Device Descriptor 
	rom USB_DEV_DSC device_dsc=
	{    
	    sizeof(USB_DEV_DSC),    // Size of this descriptor in bytes
	    DSC_DEV,                // DEVICE descriptor type
	    0x0200,                 // USB Spec Release Number in BCD format
	    0x00,                   // Class Code
	    0x00,                   // Subclass code
	    0x00,                   // Protocol code
	    EP0_BUFF_SIZE,          // Max packet size for EP0, see usbcfg.h
	    0x04D8,                 // Vendor ID
	    0x000C,                 // Product ID: PICDEM FS USB (DEMO Mode)
	    0x0000,                 // Device release number in BCD format
	    0x01,                   // Manufacturer string index
	    0x02,                   // Product string index
	    0x00,                   // Device serial number string index
	    0x01                    // Number of possible configurations
	};
	
	
		*/
	
	private String getcdPtrsDescriptorC(){
	
		return "//dejo estos punteros en una posicion fija de memoria" + ls +
				"#pragma romdata _usb_cd_ptr" + ls +
				"rom const unsigned char *rom USB_CD_Ptr[]={(rom char*)&cfg01,(rom char*)&cfg01};" + ls ;
	}
	
	private String getsdPtrsDescriptorC(){
		StringBuffer sb = new StringBuffer();
		sb.append("#pragma romdata _usb_sd_ptr" + ls +
		"rom const unsigned char *rom USB_SD_Ptr[]={");
		for(int i=0; i<stringDescriptors.size();i++){
			if (i!=0) sb.append(",");
			sb.append("(rom char*)&"+getSdName(i));
		}
		sb.append("};" + ls +
		"#pragma code sys" + ls) ;
		return sb.toString();
	}
		
	
	public String getSdName(int descNumber){
		if (descNumber <9){
			return "sd00"+descNumber;
		}
		else {
			if (descNumber > 99){
				return "sd"+ descNumber;
			}
			else return "sd0"+ descNumber;
		}
	}

	public Vector<Configuration> getConfigurations() {
		return configurations;
	}

	public void setManufacturerString(StringDescriptor sd) {
		//chequeo si esta en la coleccion de StringDescriptors
		if (!stringDescriptors.contains(sd)){
			//si no esta lo agrego
			addStringDescriptor(sd);
		}
		//seteo el nro de string descritpor del manufacturer
		manufacturerStringNumber = stringDescriptors.indexOf(sd);
	}
	
	public void setDeviceSerialNumberString(StringDescriptor sd) {
		//chequeo si esta en la coleccion de StringDescriptors
		if (!stringDescriptors.contains(sd)){
			//si no esta lo agrego
			addStringDescriptor(sd);
		}
		//seteo el nro de string descritpor del numero de serie
		deviceSerialNumberStringIndex = stringDescriptors.indexOf(sd);
	}

	public void setProductString(StringDescriptor sd) {
		//chequeo si esta en la coleccion de StringDescriptors
		if (!stringDescriptors.contains(sd)){
			//si no esta lo agrego
			addStringDescriptor(sd);
		}
		//seteo el nro de string descritpor del product
		productStringIndex = stringDescriptors.indexOf(sd);
	}

	
	public Vector<StringDescriptor> getStringDescriptors() {
		return stringDescriptors;
	}
	
	
}
